﻿#include  "StdAfx.h"
#include  <szTime.hpp>

SZ_AN_BEG

// 1601/1/1 12:00 の Julian Day Number（FILETIME は 1601/1/1 を基準とするので）
const int Julian1601 = 2305814;

// より大きな時間単位に含まれる 100 ナノ秒の個数。
const s64 Nanosec100InSec  = 10000000;
const s64 Nanosec100InMin  = 600000000;
const s64 Nanosec100InHour = 36000000000;
const s64 Nanosec100InDay  = 864000000000;

SZ_AN_END

SZ_NS_BEG(szpp)

void Time::Mdy(int j, int * mp, int * dp, int * yp) const
{
  int &m = *mp;
  int &d = *dp;
  int &y = *yp;
  j -= 1721119;
  y = ((j << 2) - 1) / 146097;
  j = (j << 2) - 1 - 146097 * y;
  d = (j >> 2);
  j = ((d << 2) + 3) / 1461;
  d = (d << 2) + 3 - 1461 * j;
  d = (d + 4) >> 2;
  m = (d * 5 - 3) / 153;
  d = d * 5 - 3 - 153 * m;
  d = (d + 5) / 5;
  y = y * 100 + j;
  if (m < 10)
    m += 3;
  else
    m -= 9, ++y;
}

void Time::Mdy(int * mp, int * dp, int * yp) const
{
  return Mdy(JulianMidnight(), mp, dp, yp);
}

int Time::JulianMidnight() const
{
  const int j = Julian();
  return (Hour() < 12 ? (j + 1) : j);
}

int Time::Julian() const
{
  const int delta = static_cast<int>((t - 12 * Nanosec100InHour) / Nanosec100InDay);
  return delta + Julian1601;
}

int Time::Jday(int m, int d, int y)
{
  if (m > 2)
    m -= 3;
  else
    m += 9, --y;

  const int c = y / 100;
  const int ya = y - 100 * c;
  const int j = ((146097 * c) >> 2) + ((1461 * ya) >> 2) + (153 * m + 2) / 5 + d + 1721119;

  // Since it still is the standard Julian Day Number measured from 12:00,
  // subtract 1 to make it non-standard Julian Day Number.
  return j - 1;
}

void Time::Extract(std::tm * tmbuf) const
{
  int m, d, y, jm = JulianMidnight();
  Mdy(jm, &m, &d, &y);

  const int yday = Jday(12, 31, y - 1);

  tmbuf->tm_year   = y - 1900;
  tmbuf->tm_mon    = m - 1;
  tmbuf->tm_mday   = d;
  tmbuf->tm_wday   = DayOfWeek();
  tmbuf->tm_yday   = (yday ? jm - yday - 1 : 0) - 1;

  tmbuf->tm_hour   = Hour();
  tmbuf->tm_min    = Minute();
  tmbuf->tm_sec    = Second();
  tmbuf->tm_isdst  = 0;
//tmbuf->tm_zone   = "GMT";
//tmbuf->tm_gmtoff = 0;
}

int Time::Year() const
{
  int m, d, y;
  Mdy(&m, &d, &y);
  return y;
}

int Time::Month() const
{
  int m, d, y;
  Mdy(&m, &d, &y);
  return m;
}

int Time::Day() const
{
  int m, d, y;
  Mdy(&m, &d, &y);
  return d;
}

int Time::DayOfYear() const
{
  const int jd = Jday(12, 31, Year() - 1);
  return JulianMidnight() - (jd + 1);
}

int Time::DayOfWeek() const
{
  return (JulianMidnight() + 1) % 7;
}

int Time::Hour() const
{
  return static_cast<int>((t % Nanosec100InDay) / Nanosec100InHour);
}

int Time::Minute() const
{
  return static_cast<int>(((t % Nanosec100InDay) % Nanosec100InHour) / Nanosec100InMin);
}

int Time::Second() const
{
  return static_cast<int>((((t % Nanosec100InDay) % Nanosec100InHour) % Nanosec100InMin) / Nanosec100InSec);
}

int Time::Nanosec100() const
{
  return static_cast<int>((((t % Nanosec100InDay) % Nanosec100InHour) % Nanosec100InMin) % Nanosec100InSec);
}

Time Time::Compose(int y, int mon, int d, int h, int m, int s, int ns100)
{
  return Time(ComposeFromJulian(Jday(mon, d, y) + 1, h, m, s, ns100));
}

Time Time::Now()
{
  SYSTEMTIME st;
  GetLocalTime(&st);

  FILETIME ft;
  SystemTimeToFileTime(&st, &ft);

  return Time(*(s64 *)&ft);
}

s64 Time::ComposeFromJulian(int jd, int h, int m, int s, int ns100)
{
  s64 val = (jd - Julian1601) * Nanosec100InDay +
            h * Nanosec100InHour +
            m * Nanosec100InMin +
            s * Nanosec100InSec +
            ns100;
  return val;
}

SZ_NS_END(szpp)
